#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Segment Simplex Grid #5Mod01.fsh   by   Yusef28
//https://www.shadertoy.com/view/NdtXDf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define FAR 30.
#define pi acos(-1.)
/*
The code is still not cleaned up here so good luck!
*/

const mat2 m = mat2( 0.80,  0.60, -0.60,  0.80 );


float noise( in vec2 p )
{
	return sin(p.x)*sin(p.y);
}

float fbm4( vec2 p )
{
    p/=1.9;
    float f = 0.0;
    f += 0.5000*noise( p ); p = m*p*2.02;
    f += 0.2500*noise( p ); p = m*p*2.03;
    //f += 0.1250*noise( p ); p = m*p*2.01;
    //f += 0.0625*noise( p ); 
    return f*1.3;
}


vec3 hash3( float n )
{
    return fract(sin(vec3(n,n+1.0,n+2.0))*vec3(43758.5453123,22578.1459123,19642.3490423));
}

vec3 snoise3( in float x )
{
#if 1    
    return -1.0 + 2.0*textureLod( texture2, vec2(x,4.5)/256.0, 0.0 ).xyz;
#else    
    float p = floor(x);
    float f = fract(x);
    f = f*f*(3.0-2.0*f);
    return -1.0 + 2.0*mix( hash3(p+0.0), hash3(p+1.0), f );
#endif    
}
float sdCappedCylinder( vec3 p, float h, float r ){
  vec2 d = abs(vec2(length(p.xz),p.y)) - vec2(h,r);
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}
float smin( float a, float b, float k ){
    float h = clamp( 0.5 + 0.5 * (b - a) / k, 0.0, 1.0 );
    return mix( b, a, h ) - k * h * (1.0 - h);
}
float smax( float a, float b, float k ){
    float h = clamp( 0.5 + 0.5 * (a - b) / k, 0.0, 1.0 );
    return mix( b, a, h ) + k * h * (1.0 - h);
}
float seggy( vec3 P, vec3 A, vec3 B){
    
    //dist auf line segment zu punkt
    //nahrest dist auf line zu punkt
    //P = A + t*(B-A);
    //dot((P-P3),(B-A)) = 0
    //(A+t*(B-A)-P3)*(B-A)) = 0;
    //A*(B-A)+t*(B-A)*(B-A)-P3*(B-A) = 0
    //A*(B-A) - P3*(B-A) + t*(B-A)*(B-A)
    //(A-P3)*(B-A) + t*(B-A)*(B-A)
    //t = dot((A-P3),(B-A)) / dot((B-A),(B-A));
    vec3 AP = P-A;
    vec3 BA = B-A;
    
    float t = clamp(dot(AP,BA)/
                    dot(BA,BA), 
                    0., 1.);
                    
    vec3 P3 = A + t*BA;                
    float dist = length(P - P3) - 0.02;
    return dist;
}


vec2 planeVonTri(vec3 p, vec3 A, vec3 B, vec3 C){
    
    vec3 BA = A - B;
    vec3 CA = A - C;
    vec3 n  = normalize(cross(BA,CA));
    //where is the intersection of line and plane?
    //plane = dot(n,P) = 0
    //line = ro + rd*t = P
    float t = dot(n,p-A);
    
    //dist from point to line AB, BC, and CA
    float dAB = length(cross(p-A, B-A));
    float dBC = length(cross(p-B,C-B));
    float dCA = length(cross(p-C, A-C));

    //I'm pretty certain there is an easier way to do this
    //I'l have to experiment with it later
    float edgeLines = min(
        abs(dAB - dBC)/(1.-float(dCA < min(dAB,dBC))),
    min(abs(dBC - dCA)/(1.-float(dAB < min(dBC,dCA))),
        abs(dCA - dAB)/(1.-float(dBC < min(dCA,dAB)))
        ));

                      
    float bumpLines = min(dAB,min(dBC,dCA));
    
    float oppLines = max(dAB,max(dBC,dCA));
    float distCenter = bumpLines;
    float planeHeight = t + distCenter/1.8;
    if(distCenter == dAB) planeHeight += sin(distCenter*130.)/400. ;
 
 return vec2(planeHeight, edgeLines*2.);
 
}


mat2 rot(float a){
    float cs = cos(a),si = sin(a);
    return mat2(cs, si, -si, cs);
}


float objectID = 0.;
float glow = 0.;

//FROM DAVE HOSKINS

//  1 out, 2 in...
float hash12(vec2 p)
{
	vec3 p3  = fract(vec3(p.xyx) * .1031);
    p3 += dot(p3, p3.yzx + 33.33);
    return fract((p3.x + p3.y) * p3.z);
}
//FROM DAVE HOSKINS
vec3 hash33(vec3 p3)
{
	p3 = fract(p3 * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yxz+33.33);
    return fract((p3.xxy + p3.yxx)*p3.zyx);

}

vec3 objColGlobal = vec3(0.);

float map(vec3 p){

    
    p *= 0.9;   
    
    p.xz *= mat2(1.1547, 0., 1.1547*0.5,1.);
    float sphere_radius = 0.35;
    vec3 sp = p;
   // sp.y -= 0.23;
    //float k = length(sp) - sphere_radius;
    float alle = 100.;
    //sp = p;
    

    //sp.y += 0.5;
    //sp.xz *= rot(sp.y*3.);
    
    
    
    
    sp.xz = fract(p.xz)-0.5;
    vec2 id = floor(p.xz);
    float ball_gross = fract(sin(dot(vec2(12.55,74.2),id))*452354.);
    float t = 0.;//iTime;
    
    float gross = 1.3;
    
    float height = fbm4(id+t)*gross;
    float heightL = fbm4((id + vec2(0.,1.))+t)*gross;
    float heightR = fbm4((id + vec2(0.,-1.))+t)*gross;
    float heightV = fbm4((id + vec2(-1.,0.))+t)*gross;
    float heightH = fbm4((id + vec2(1.,0.))+t)*gross;
    
    
    float k = seggy(sp, vec3(0.,height,0.), vec3(-1.,heightV,0.));
    alle = smin(alle, k, 0.);
    k = seggy(sp, vec3(0.,height,0.), vec3(0., heightL,1.0));
    alle = smin(alle, k, 0.);
    k = seggy(sp, vec3(0.,height,0.), vec3(0.,heightR,-1.));
    alle = smin(alle, k, 0.);
    k = seggy(sp, vec3(0.,height,0.), vec3(1.0,heightH,0.0));
    alle = smin(alle, k, 0.);
    
    //k = length(sp - vec3(0.,height,0.))-0.03-ball_gross*0.037;
    //alle = smin(alle, k, 0.);
    
    //k = seggy(sp - vec3(id.x, height, id.y), vec3(id.x, height, id.y), 
    //                   vec3(0.0,0.,0.0));
    //alle = smin(alle, k, 0.);
    
    vec3 st = p;
    
    //this screwed me up for a (h)while
   // st.y += 0.5;
    
    //HERE:
    //I create a new shifted coord system so that I can get 
    //that pesky diagonal segment
    st.xz = fract(p.xz-0.5)-0.5;
    vec2 id2 = floor(p.xz-0.5);
    
    
    //for floor here, actually:
    //the mid point is the + 0.5,0.5
    //the bottom is 0,0 because that is the floor value, id
    //and the top would have to be + 1.,1.
    
    float heightDB = fbm4(id2 +t)*gross;
    float heightDT = fbm4(id2 + vec2(1.) +t)*gross;
    
    /////
    float heightTLT = fbm4(id2 + vec2(0.,1.) +t)*gross;
    float heightBRB = fbm4(id2 + vec2(1.,0.) +t)*gross;
    
    //float heightMD = fbm4(id2 - vec2(0.5))*gross;
    
    //THE DIAGONAL!!
    k = seggy(st, vec3(-0.5, heightDB, -0.5), 
                  vec3( 0.5, heightDT,  0.5) );
                  
    alle = smin(alle, k, 0.);
    
    //check which side of the diagonal of the square we are on
    //and make a plane with the three coordinates of that triangle
    
    vec2 pl = st.x < st.z 
    
                         ?
                        
               planeVonTri(st,
                     vec3( 0.5, heightDT,  0.5),
                     vec3(-0.5, heightDB, -0.5),
                     vec3(-0.5, heightTLT, 0.5) )
                     
                         : 
                        
               planeVonTri(st,
                     //you need to have this exact order for A,B and C!
                     vec3(-0.5, heightDB, -0.5),
                     vec3( 0.5, heightDT,  0.5),
                     
                     vec3( 0.5, heightBRB, -0.5) );
    
    //calculate colors
    float colID = hash12(floor(p.xz - 0.5) + sign(st.x-st.z)*80.)+0.2;
    objColGlobal = 0.5+0.5*cos(vec3(colID*0.1,colID*0.4,colID) + vec3(2.,5.,5.)/4. + colID*80.)/1.5;
    
    //fake ambient occlusion in the holes here.
    objColGlobal = mix(objColGlobal, 
                   objColGlobal*.82, 
                   smoothstep(0.2,0.02,pl.y)*4.);
    
    //kind of a Shane x Nusan hybrid ID check
    if(pl.x < 0.005){
       // glow += 0.0001/pow(pl,0.2);
        objectID = 1.;   
    }
  // if(objColGlobal.x > 2.) glow += 0.0005/pow(pl.x,2.);
    alle = min(alle, pl.x);

   //
   //alle = min(alle, length(st)-0.15);
    return alle;// min(alle, sp.y+0.7-fbm4(p.xz));
    
}

//FROM SHANE
float trace(vec3 ro, vec3 rd){
   
    float t = 0., d;
    
    for (int i = 0; i < 96; i++){

        d = map(ro + rd*t);
        
        if(abs(d)<.001 || t>FAR) break;        
        
        //low step to get rid of artifacts on object ids
        t += d*.85;  // Using more accuracy, in the first pass.
    }
    
    return t;
}

//FROM SHANE
float softShadow(vec3 ro, vec3 lp, float k){

    // More would be nicer. More is always nicer, but not really affordable... Not on my slow test machine, anyway.
    const int maxIterationsShad = 24; 
    
    vec3 rd = lp - ro; // Unnormalized direction ray.

    float shade = 1.;
    float dist = .002;    
    float end = max(length(rd), .001);
    float stepDist = end/float(maxIterationsShad);
    
    rd /= end;

    // Max shadow iterations - More iterations make nicer shadows, but slow things down. Obviously, the lowest 
    // number to give a decent shadow is the best one to choose. 
    for (int i = 0; i<maxIterationsShad; i++){

        float h = map(ro + rd*dist);
        //shade = min(shade, k*h/dist);
        shade = min(shade, smoothstep(0., 1., k*h/dist)); // Subtle difference. Thanks to IQ for this tidbit.
        // So many options here, and none are perfect: dist += min(h, .2), dist += clamp(h, .01, .2), 
        // clamp(h, .02, stepDist*2.), etc.
        dist += clamp(h, .02, .25);
        
        // Early exits from accumulative distance function calls tend to be a good thing.
        if (h<0. || dist>end) break; 
        //if (h<.001 || dist > end) break; // If you're prepared to put up with more artifacts.
    }

    // I've added 0.5 to the final shade value, which lightens the shadow a bit. It's a preference thing. 
    // Really dark shadows look too brutal to me.
    return min(max(shade, 0.) + .25, 1.); 
}

//FROM SHANE?
vec3 getNormal(in vec3 p) {
	const vec2 e = vec2(.001, 0);
	return normalize(vec3(map(p + e.xyy) - map(p - e.xyy), map(p + e.yxy) - map(p - e.yxy),	map(p + e.yyx) - map(p - e.yyx)));
}

vec3 triPlanar(vec3 p, vec3 n){
    n = max(abs(n), 0.001);
    vec3 tex = vec3(texture2D(texture1,p.xy).rgb*n.z +
                    texture2D(texture1,p.yz).rgb*n.x +
                    texture2D(texture1,p.xz).rgb*n.y
                    );
                    
    return tex;
}
//FROM SHANE!
vec3 doColor(in vec3 sp, in vec3 rd, in vec3 sn, in vec3 lp, float t){
    
    vec3 ld = lp-sp; // Light direction vector.
    float lDist = max(length(ld), .001); // Light to surface distance.
    ld /= lDist; // Normalizing the light vector.
    
    // Attenuating the light, based on distance.
    float atten = 1. / (1. + lDist*.2 + lDist*lDist*.1);
    
    // Standard diffuse term.
    float diff = max(dot(sn, ld), 0.);
    // Standard specualr term.
    float spec = pow(max( dot( reflect(-ld, sn), -rd ), 0.), 8.);
    
    // Coloring the object. You could set it to a single color, to
    // make things simpler, if you wanted.
    vec3 objCol = objectID == 1.    ? 
    objColGlobal*triPlanar(sp,sn).x :
    vec3(.5)*0.7;
    //objCol = objectID == 2. ? vec3(1.) : 
      //    objCol;//getObjectColor(sp);
   // if(objectID == 2.) objCol = vec3(1.);
    
    float specFact = objectID == 1. ? 8. : 6.;
    // Combining the above terms to produce the final scene color.
    vec3 sceneCol = (objCol*(diff*8. ) + vec3(.8, .5, .2)*spec*specFact) * atten;
    
    
    // Fog factor -- based on the distance from the camera.
    float fogF = smoothstep(0., .95, pow(t/FAR,5.));
    //
    // Applying the background fog. Just black, in this case, but you could
    // render sky, etc, as well.
   // sceneCol = glow*0.2;
    sceneCol = mix(sceneCol, vec3(0.), fogF); 

    //sceneCol = mix(sceneCol, sceneCol + glow*0.2, clamp(.2-fogF,0.,1.)); 
    // Return the color. Performed once every pass... of which there are
    // only two, in this particular instance.
    return sceneCol;
    
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 

    // Screen coordinates.
	vec2 uv = (fragCoord.xy - iResolution.xy*.5) / iResolution.y;
    
    // Unit direction ray.
    vec3 rd = normalize(vec3(uv, 1.));
    rd.yz *= rot(-0.5);

    // Some cheap camera movement, for a bit of a look around. I use this far
    // too often. I'm even beginning to bore myself at this point. :)
    float cs = cos(iTime * .25), si = sin(iTime * .25);
    //rd.xy = mat2(cs, si, -si, cs)*rd.xy;
    //rd.xz = mat2(cs, si, -si, cs)*rd.xz;
    
    // Ray origin. Doubling as the surface position, in this particular example.
    // I hope that doesn't confuse anyone.
    vec3 ro = vec3(0., 4. + sin(iTime)*0.1, -4.5 + iTime*1.);
    
    // Light position. Set in the vicinity the ray origin.
    vec3 lp = ro + vec3(0., 2., 3.5);
    
    vec3 sceneColor;
    float t = trace(ro, rd);
    //sceneColor = mix(sceneColor, vec3(0.3,0.051,0.), clamp(pow(t/FAR, 20.),0.,1.));
    if(t < FAR){
    ro += rd*t;
    vec3 sn = getNormal(ro);
    sceneColor = doColor(ro, rd, sn, lp, t);
    float sh = softShadow(ro +  sn*.0015, lp, 16.);
    
    ///sceneColor += 
    sceneColor *= sh;
    //sceneColor += glow;
    }
    else{
    
    sceneColor = vec3(0.);//texture2D(texture1,rd).xyz*0.51;

    }
    
    uv = fragCoord/iResolution.xy;
    uv *=  1.0 - uv.yx;
    float vig = uv.x*uv.y * 15.0;
    
    vig = pow(vig, 0.15);
    
    // Clamping the scene color, performing some rough gamma correction (the "sqrt" bit), then 
    // presenting it to the screen.
	fragColor = vec4(sqrt(clamp(sceneColor*vig, 0., 1.)), 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

